/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.client.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.mendix.cf.client.MxCfClientResult;
import com.mendix.cf.client.commands.Command;
import com.mendix.cf.client.util.MxCfClientUtil;
import com.mendix.cf.lib.MxCfCredentials;
import com.mendix.cf.lib.MxCfException;
import com.mendix.cf.lib.commands.MxCfPushMDA;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PushCommand
extends Command {
    private static final Logger logger = LogManager.getLogger(PushCommand.class);
    public static final String MDAFILE = "mdafile";
    public static final String ORGANIZATION = "organization";
    public static final String SPACE = "space";
    public static final String APPNAME = "appname";
    public static final String MENDIX_ADMIN_PASSWORD = "mendix_admin_password";
    public static final String BUILDPACK = "buildpack";

    @Override
    public String getName() {
        return "push";
    }

    @Override
    public void execute(JsonNode arguments, MxCfCredentials credentials, MxCfClientResult result) {
        try {
            PushCommand.push(arguments, credentials, result);
        }
        catch (MxCfException e) {
            logger.info("CloudFoundryException: " + e.getMessage());
            result.addExceptionError(e);
        }
        catch (InvalidPathException e) {
            logger.info("InvalidPathException: ", (Object)e.getMessage());
            result.addExceptionError(e);
            return;
        }
        catch (Exception e) {
            logger.info("Exception " + e.getClass().getName() + ": " + e.getMessage());
            result.addExceptionError(e);
        }
    }

    private static void push(JsonNode arguments, MxCfCredentials credentials, MxCfClientResult result) throws MxCfException, InvalidPathException {
        String mdaFile = MxCfClientUtil.getAndValidate(arguments, MDAFILE, result);
        String appName = MxCfClientUtil.getAndValidate(arguments, APPNAME, result);
        String adminPassword = MxCfClientUtil.getAndValidate(arguments, MENDIX_ADMIN_PASSWORD, result);
        String organization = MxCfClientUtil.getAndValidate(arguments, ORGANIZATION, result);
        String space = MxCfClientUtil.getAndValidate(arguments, SPACE, result);
        String buildpack = MxCfClientUtil.getAndValidate(arguments, BUILDPACK, result);
        if (result.hasErrors()) {
            return;
        }
        String errorMessage = "The MDA file '" + mdaFile + "' cannot be found.";
        Path mdaFilePath = Paths.get(mdaFile, new String[0]);
        if (Files.notExists(mdaFilePath, new LinkOption[0])) {
            logger.info(errorMessage);
            result.addError(errorMessage);
            return;
        }
        MxCfPushMDA push = new MxCfPushMDA(appName, adminPassword, credentials, organization, space, buildpack, mdaFilePath);
        push.executeCommand();
    }
}

