/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.client.commands;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mendix.cf.client.MxCfClientResult;
import com.mendix.cf.client.commands.Command;
import com.mendix.cf.lib.MxCfCredentials;
import com.mendix.cf.lib.MxCfOrganization;
import com.mendix.cf.lib.MxCfSpace;
import com.mendix.cf.lib.commands.MxCfLogin;
import java.util.List;

public class LoginCommand
extends Command {
    private static final String SPACES = "spaces";
    private static final String APPS = "apps";
    private static final String NAME = "name";
    protected JsonNodeFactory factory = new JsonNodeFactory(false);
    protected JsonFactory jsonFactory = new JsonFactory();
    protected ObjectMapper mapper = null;
    protected boolean hasErrors = false;

    @Override
    public String getName() {
        return "login";
    }

    @Override
    public void execute(JsonNode arguments, MxCfCredentials credentials, MxCfClientResult result) {
        this.login(arguments, credentials, result);
    }

    private void login(JsonNode arguments, MxCfCredentials credentials, MxCfClientResult result) {
        MxCfLogin login = new MxCfLogin();
        login.loginToCloudFoundry(credentials);
        ObjectNode orgs = this.createJsonForOrganizations(login);
        result.setOrganizationsNode(orgs);
        ObjectNode domains = this.createJsonForDomains(login);
        result.setDomains(domains);
    }

    private ObjectNode createJsonForOrganizations(MxCfLogin login) {
        ObjectNode root = this.factory.objectNode();
        ArrayNode organizationsNode = this.factory.arrayNode();
        root.set("organizations", (JsonNode)organizationsNode);
        List<MxCfOrganization> organizations = login.getOrganizations();
        for (MxCfOrganization organization : organizations) {
            ObjectNode organizationNode = this.factory.objectNode();
            organizationNode.put(NAME, organization.getName());
            ArrayNode spacesNode = this.createJsonForSpaces(organization);
            organizationNode.set(SPACES, (JsonNode)spacesNode);
            organizationsNode.add((JsonNode)organizationNode);
        }
        return root;
    }

    private ArrayNode createJsonForSpaces(MxCfOrganization organization) {
        ArrayNode spacesNode = this.factory.arrayNode();
        for (MxCfSpace space : organization.getSpaces()) {
            ObjectNode spaceNode = this.factory.objectNode();
            spaceNode.put(NAME, space.getName());
            ArrayNode appsNode = this.createJsonForApps(space);
            spaceNode.set(APPS, (JsonNode)appsNode);
            spacesNode.add((JsonNode)spaceNode);
        }
        return spacesNode;
    }

    private ArrayNode createJsonForApps(MxCfSpace space) {
        ArrayNode appsNode = this.factory.arrayNode();
        space.getApplications().forEach(arg_0 -> ((ArrayNode)appsNode).add(arg_0));
        return appsNode;
    }

    private ObjectNode createJsonForDomains(MxCfLogin login) {
        ObjectNode root = this.factory.objectNode();
        ArrayNode domainsNode = this.factory.arrayNode();
        root.set("domains", (JsonNode)domainsNode);
        login.getDomains().forEach(arg_0 -> ((ArrayNode)domainsNode).add(arg_0));
        return root;
    }
}

