/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.mendix.cf.client.CredentialsParser;
import com.mendix.cf.client.MxCfClientResult;
import com.mendix.cf.client.commands.Command;
import com.mendix.cf.lib.MxCfCredentials;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class RequestHandler {
    private static final Logger logger = LogManager.getLogger(RequestHandler.class);
    private final CredentialsParser credentialsParser;
    Map<String, Command> commandMap = new HashMap<String, Command>();

    public RequestHandler(CredentialsParser credentialsParser, Iterable<Command> commands) {
        this.credentialsParser = credentialsParser;
        for (Command command : commands) {
            this.commandMap.put(command.getName(), command);
        }
    }

    public void performCommand(String commandName, JsonNode node, MxCfClientResult result) {
        Command command = this.commandMap.get(commandName);
        if (command == null) {
            logger.info("Incorrect command [" + commandName + "].");
            String commandNames = StringUtils.collectionToCommaDelimitedString(this.commandMap.keySet());
            result.addError("Incorrect command [" + commandName + "]. Available commands are: " + commandNames);
            return;
        }
        MxCfCredentials credentials = this.credentialsParser.parseCredentials(node, result);
        if (credentials == null) {
            return;
        }
        command.execute(node, credentials, result);
    }
}

