/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.client;

import com.mendix.cf.client.MxCfClientOptions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptionHandler {
    private static final String INPUT = "input";
    private static final Logger logger = LogManager.getLogger(OptionHandler.class);

    public MxCfClientOptions handleOptions(String[] args) {
        Options options = new Options();
        Option opt = new Option(INPUT, true, "input file with JSON arguments");
        options.addOption(opt);
        CommandLine cmd = null;
        try {
            cmd = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            logger.info(e.getMessage());
            throw new IllegalArgumentException("Incorrect options, only -input <INPUTFILE> allowed.");
        }
        List<String> arguments = Arrays.asList(cmd.getArgs());
        if (arguments.size() != 1) {
            String errorMessage = "Incorrect number of arguments, one expected.";
            logger.info(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        MxCfClientOptions result = new MxCfClientOptions();
        result.setCommandName(arguments.get(0));
        if (cmd.hasOption(INPUT)) {
            result.setInputFile(cmd.getOptionValue(INPUT));
        }
        return result;
    }
}

