/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mendix.cf.lib.MxCfException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.client.ResourceAccessException;

public class MxCfClientResult {
    private static final String ERRORS = "errors";
    private static final Logger logger = LogManager.getLogger(MxCfClientResult.class);
    public static final String ORGANIZATIONS = "organizations";
    public static final String DOMAINS = "domains";
    public static final String STATUS = "status";
    protected JsonNodeFactory factory = null;
    protected JsonFactory jsonFactory = null;
    protected JsonGenerator generator = null;
    protected ObjectMapper mapper = null;
    protected ObjectNode root = null;
    protected ArrayNode errors = null;
    protected boolean hasErrors = false;
    protected boolean hasExceptions = false;

    public MxCfClientResult() {
        try {
            this.factory = new JsonNodeFactory(false);
            this.jsonFactory = new JsonFactory();
            this.generator = this.jsonFactory.createGenerator((OutputStream)System.out);
            this.mapper = new ObjectMapper();
            this.root = this.factory.objectNode();
            this.errors = this.factory.arrayNode();
            this.root.set(ERRORS, (JsonNode)this.errors);
        }
        catch (Exception e) {
            this.exitOnExceptionError(e);
        }
    }

    public boolean hasErrors() {
        return this.hasErrors || this.hasExceptions;
    }

    public void addError(String error) {
        this.hasErrors = true;
        this.errors.add(error);
    }

    public void addExceptionError(Throwable e) {
        if (e instanceof MxCfException) {
            MxCfException cfExp = (MxCfException)e;
            if (cfExp.getMessage() != null && cfExp.getMessage().startsWith("Client error")) {
                logger.info("404: " + cfExp.getMessage());
                this.addError("Cannot connect to the specified API endpoint.");
            } else if (cfExp.getMessage() != null && cfExp.getMessage().startsWith("error=\"access_denied\"")) {
                logger.info("U/P: " + cfExp.getMessage());
                this.addError("The combination of user name and password is incorrect.");
            } else if (cfExp.getMessage() != null && cfExp.getMessage().startsWith("Application not found")) {
                logger.info("Application does not exist");
                this.addError("The specified application does not exist.");
            } else if (cfExp.getMessage() != null && cfExp.getMessage().startsWith("The app name is taken")) {
                logger.info(cfExp.getMessage());
                this.addError(cfExp.getMessage());
            } else if (cfExp.getMessage() != null && cfExp.getMessage().startsWith("The host is taken")) {
                logger.info("The app name is not available");
                this.addError("The app name is not available");
            } else {
                this.hasExceptions = true;
                this.addError(e.getClass().getName() + " : " + e.getMessage());
            }
        } else if (e instanceof IllegalArgumentException) {
            if (e.getMessage() != null && e.getMessage().startsWith("No matching organization and space found")) {
                logger.info("No matching organization and space found");
                this.addError("The specified combination of organization and space does not exist.");
            } else {
                this.hasExceptions = true;
                this.addError(e.getClass().getName() + " : " + e.getMessage());
            }
        } else if (e instanceof ResourceAccessException) {
            if (e.getMessage() != null && e.getMessage().startsWith("I/O error on GET request")) {
                this.addError("Cannot connect to the specified API endpoint.");
            } else {
                this.hasExceptions = true;
                this.addError(e.getClass().getName() + " : " + e.getMessage());
            }
        } else {
            this.hasExceptions = true;
            this.addError(e.getClass().getName() + " : " + e.getMessage());
        }
    }

    public void setOrganizationsNode(ObjectNode node) {
        this.root.set(ORGANIZATIONS, node.get(ORGANIZATIONS));
    }

    public void print() {
        if (this.hasExceptions) {
            this.root.put(STATUS, "exception");
        } else if (this.hasErrors()) {
            this.root.put(STATUS, "fail");
        } else {
            this.root.put(STATUS, "success");
        }
        try {
            this.mapper.writeTree(this.generator, (JsonNode)this.root);
        }
        catch (Exception e) {
            this.exitOnExceptionError(e);
        }
    }

    private void exitOnExceptionError(Exception e) {
        logger.error("Caught " + e.getClass().getName() + ": " + e.getMessage() + " while generating JSON:");
        e.printStackTrace();
        System.out.println("{ \"status\" : \"exception\", \"errors\" : [\"An exception of type " + e.getClass().getName() + " occurred while generating JSON.\"] }");
    }

    public void setDomains(ObjectNode domainsNode) {
        this.root.set(DOMAINS, domainsNode.get(DOMAINS));
    }
}

