/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.cf.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.mendix.cf.client.CredentialsParser;
import com.mendix.cf.client.MxCfClientOptions;
import com.mendix.cf.client.MxCfClientResult;
import com.mendix.cf.client.OptionHandler;
import com.mendix.cf.client.RequestHandler;
import com.mendix.cf.client.commands.Command;
import com.mendix.cf.client.commands.CreateAppCommand;
import com.mendix.cf.client.commands.LoginCommand;
import com.mendix.cf.client.commands.PushCommand;
import com.mendix.cf.client.util.JsonUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MxCfClient {
    private static final Logger logger = LogManager.getLogger(MxCfClient.class);

    public static void main(String[] args) {
        MxCfClientResult result = new MxCfClientResult();
        try {
            MxCfClient.doProcess(args, result);
        }
        catch (Throwable e) {
            logger.info("MxCfClient failed with unexpected exception: " + e.getClass().getName() + ": " + e.getMessage());
            result.addExceptionError(e);
        }
        result.print();
    }

    static void doProcess(String[] args, MxCfClientResult result) {
        JsonNode node;
        MxCfClientOptions options;
        OptionHandler optionHandler = new OptionHandler();
        CredentialsParser credentialsParser = new CredentialsParser();
        List<Command> commands = Arrays.asList(new LoginCommand(), new PushCommand(), new CreateAppCommand());
        RequestHandler requestHandler = new RequestHandler(credentialsParser, commands);
        try {
            options = optionHandler.handleOptions(args);
        }
        catch (IllegalArgumentException e) {
            logger.info("Illegal argument: " + e.getMessage());
            result.addError(e.getMessage());
            return;
        }
        if (options.getInputFile() != null) {
            try {
                System.setIn(new FileInputStream(options.getInputFile()));
            }
            catch (FileNotFoundException e) {
                String errorMessage = "Input file [" + options.getInputFile() + "] not found";
                logger.info(errorMessage);
                result.addError(errorMessage);
                return;
            }
        }
        try {
            node = JsonUtil.parseJson(System.in);
        }
        catch (IllegalArgumentException e) {
            logger.info("Illegal argument: " + e.getMessage());
            result.addError(e.getMessage());
            return;
        }
        String commandName = options.getCommandName();
        requestHandler.performCommand(commandName, node, result);
    }
}

