/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v3.Checksum;
import org.cloudfoundry.client.v3.ChecksumType;
import org.cloudfoundry.client.v3.resourcematch.ListMatchingResourcesRequest;
import org.cloudfoundry.client.v3.resourcematch.ListMatchingResourcesResponse;
import org.cloudfoundry.client.v3.resourcematch.MatchedResource;
import org.cloudfoundry.util.FileUtils;
import org.cloudfoundry.util.SizeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class ResourceMatchingUtilsV3 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.resource-matching-v3");

    private ResourceMatchingUtilsV3() {
    }

    public static Mono<List<MatchedResource>> getMatchedResources(CloudFoundryClient cloudFoundryClient, Path application) {
        return (Files.isDirectory(application, new LinkOption[0]) ? ResourceMatchingUtilsV3.getArtifactMetadataFromDirectory(application) : ResourceMatchingUtilsV3.getArtifactMetadataFromZip(application)).collectList().flatMap(artifactMetadatas -> ResourceMatchingUtilsV3.requestListMatchingResources(cloudFoundryClient, artifactMetadatas)).map(ListMatchingResourcesResponse::getResources).doOnNext(matched -> LOGGER.debug("{} resources matched totaling {}", (Object)matched.size(), (Object)SizeUtils.asIbi(matched.stream().mapToInt(MatchedResource::getSize).sum()))).subscribeOn(Schedulers.boundedElastic());
    }

    private static Flux<ArtifactMetadata> getArtifactMetadataFromDirectory(Path application) {
        return Flux.defer(() -> {
            try {
                return Flux.fromStream(Files.walk(application, new FileVisitOption[0]));
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path -> new ArtifactMetadata(Checksum.builder().type(ChecksumType.SHA1).value(FileUtils.hash(path)).build(), FileUtils.getRelativePathName(application, path), FileUtils.permissions(path), FileUtils.size(path)));
    }

    private static Flux<ArtifactMetadata> getArtifactMetadataFromZip(Path application) {
        ArrayList<ArtifactMetadata> artifactMetadatas = new ArrayList<ArtifactMetadata>();
        try (ZipFile zipFile = new ZipFile(application.toFile());){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    Checksum checksum = Checksum.builder().type(ChecksumType.SHA1).value(FileUtils.hash(in)).build();
                    String path = entry.getName();
                    String permissions = FileUtils.permissions(entry.getUnixMode());
                    int size = (int)entry.getSize();
                    artifactMetadatas.add(new ArtifactMetadata(checksum, path, permissions, size));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return Flux.fromIterable(artifactMetadatas);
    }

    private static Mono<ListMatchingResourcesResponse> requestListMatchingResources(CloudFoundryClient cloudFoundryClient, Collection<ArtifactMetadata> artifactMetadatas) {
        ListMatchingResourcesRequest request = artifactMetadatas.stream().reduce(ListMatchingResourcesRequest.builder(), (builder, artifactMetadata) -> builder.resource(MatchedResource.builder().checksum(artifactMetadata.getChecksum()).mode(artifactMetadata.getPermissions()).size(Integer.valueOf(artifactMetadata.getSize())).path(artifactMetadata.getPath()).build()), (a, b) -> a.addAllResources((Iterable)b.build().getResources())).build();
        return cloudFoundryClient.resourceMatchV3().list(request);
    }

    public static final class ArtifactMetadata {
        private final Checksum checksum;
        private final String path;
        private final String permissions;
        private final int size;

        public ArtifactMetadata(Checksum checksum, String path, String permissions, int size) {
            this.checksum = checksum;
            this.path = path;
            this.permissions = permissions;
            this.size = size;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public String getPath() {
            return this.path;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public int getSize() {
            return this.size;
        }
    }
}

