/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.stacks;

import java.util.Map;
import org.cloudfoundry.client.v3.stacks.CreateStackRequest;
import org.cloudfoundry.client.v3.stacks.CreateStackResponse;
import org.cloudfoundry.client.v3.stacks.DeleteStackRequest;
import org.cloudfoundry.client.v3.stacks.GetStackRequest;
import org.cloudfoundry.client.v3.stacks.GetStackResponse;
import org.cloudfoundry.client.v3.stacks.ListStacksRequest;
import org.cloudfoundry.client.v3.stacks.ListStacksResponse;
import org.cloudfoundry.client.v3.stacks.StacksV3;
import org.cloudfoundry.client.v3.stacks.UpdateStackRequest;
import org.cloudfoundry.client.v3.stacks.UpdateStackResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class ReactorStacksV3
extends AbstractClientV3Operations
implements StacksV3 {
    public ReactorStacksV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateStackResponse> create(CreateStackRequest request) {
        return this.post(request, CreateStackResponse.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"stacks"})).checkpoint();
    }

    public Mono<Void> delete(DeleteStackRequest request) {
        return this.delete(request, Void.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"stacks", request.getStackId()})).checkpoint();
    }

    public Mono<GetStackResponse> get(GetStackRequest request) {
        return this.get((Object)request, GetStackResponse.class, (UriComponentsBuilder uriComponentsBuilder) -> uriComponentsBuilder.pathSegment(new String[]{"stacks", request.getStackId()})).checkpoint();
    }

    public Mono<ListStacksResponse> list(ListStacksRequest request) {
        return this.get((Object)request, ListStacksResponse.class, (UriComponentsBuilder uriComponentsBuilder) -> uriComponentsBuilder.pathSegment(new String[]{"stacks"})).checkpoint();
    }

    public Mono<UpdateStackResponse> update(UpdateStackRequest request) {
        return this.patch(request, UpdateStackResponse.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"stacks", request.getStackId()})).checkpoint();
    }
}

