/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.groups.Group;
import org.cloudfoundry.uaa.groups._ListGroupsResponse;
import org.immutables.value.Generated;

@Generated(from="_ListGroupsResponse", generator="Immutables")
public final class ListGroupsResponse
extends _ListGroupsResponse {
    private final Integer itemsPerPage;
    private final List<Group> resources;
    private final List<String> schemas;
    private final Integer startIndex;
    private final Integer totalResults;

    private ListGroupsResponse(Builder builder) {
        this.itemsPerPage = builder.itemsPerPage;
        this.resources = ListGroupsResponse.createUnmodifiableList(true, builder.resources);
        this.schemas = ListGroupsResponse.createUnmodifiableList(true, builder.schemas);
        this.startIndex = builder.startIndex;
        this.totalResults = builder.totalResults;
    }

    @Override
    @JsonProperty(value="itemsPerPage")
    public Integer getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    @JsonProperty(value="resources")
    public List<Group> getResources() {
        return this.resources;
    }

    @Override
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty(value="startIndex")
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    @JsonProperty(value="totalResults")
    public Integer getTotalResults() {
        return this.totalResults;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListGroupsResponse && this.equalTo((ListGroupsResponse)another);
    }

    private boolean equalTo(ListGroupsResponse another) {
        return this.itemsPerPage.equals(another.itemsPerPage) && this.resources.equals(another.resources) && this.schemas.equals(another.schemas) && this.startIndex.equals(another.startIndex) && this.totalResults.equals(another.totalResults);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.itemsPerPage.hashCode();
        h += (h << 5) + this.resources.hashCode();
        h += (h << 5) + this.schemas.hashCode();
        h += (h << 5) + this.startIndex.hashCode();
        h += (h << 5) + this.totalResults.hashCode();
        return h;
    }

    public String toString() {
        return "ListGroupsResponse{itemsPerPage=" + this.itemsPerPage + ", resources=" + this.resources + ", schemas=" + this.schemas + ", startIndex=" + this.startIndex + ", totalResults=" + this.totalResults + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListGroupsResponse fromJson(Json json) {
        Builder builder = ListGroupsResponse.builder();
        if (json.itemsPerPage != null) {
            builder.itemsPerPage(json.itemsPerPage);
        }
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        if (json.schemas != null) {
            builder.addAllSchemas(json.schemas);
        }
        if (json.startIndex != null) {
            builder.startIndex(json.startIndex);
        }
        if (json.totalResults != null) {
            builder.totalResults(json.totalResults);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListGroupsResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ITEMS_PER_PAGE = 1L;
        private static final long INIT_BIT_START_INDEX = 2L;
        private static final long INIT_BIT_TOTAL_RESULTS = 4L;
        private long initBits = 7L;
        private Integer itemsPerPage;
        private List<Group> resources = new ArrayList<Group>();
        private List<String> schemas = new ArrayList<String>();
        private Integer startIndex;
        private Integer totalResults;

        private Builder() {
        }

        public final Builder from(ListGroupsResponse instance) {
            return this.from((_ListGroupsResponse)instance);
        }

        final Builder from(_ListGroupsResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.itemsPerPage(instance.getItemsPerPage());
            this.addAllResources(instance.getResources());
            this.addAllSchemas(instance.getSchemas());
            this.startIndex(instance.getStartIndex());
            this.totalResults(instance.getTotalResults());
            return this;
        }

        @JsonProperty(value="itemsPerPage")
        public final Builder itemsPerPage(Integer itemsPerPage) {
            this.itemsPerPage = Objects.requireNonNull(itemsPerPage, "itemsPerPage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder resource(Group element) {
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resources(Group ... elements) {
            for (Group element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        @JsonProperty(value="resources")
        public final Builder resources(Iterable<? extends Group> elements) {
            this.resources.clear();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends Group> elements) {
            for (Group group : elements) {
                this.resources.add(Objects.requireNonNull(group, "resources element"));
            }
            return this;
        }

        public final Builder schema(String element) {
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            return this;
        }

        public final Builder schemas(String ... elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="schemas")
        public final Builder schemas(Iterable<String> elements) {
            this.schemas.clear();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="startIndex")
        public final Builder startIndex(Integer startIndex) {
            this.startIndex = Objects.requireNonNull(startIndex, "startIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="totalResults")
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = Objects.requireNonNull(totalResults, "totalResults");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ListGroupsResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListGroupsResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("itemsPerPage");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("startIndex");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalResults");
            }
            return "Cannot build ListGroupsResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ListGroupsResponse", generator="Immutables")
    static final class Json
    extends _ListGroupsResponse {
        Integer itemsPerPage;
        List<Group> resources = Collections.emptyList();
        List<String> schemas = Collections.emptyList();
        Integer startIndex;
        Integer totalResults;

        Json() {
        }

        @JsonProperty(value="itemsPerPage")
        public void setItemsPerPage(Integer itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
        }

        @JsonProperty(value="resources")
        public void setResources(List<Group> resources) {
            this.resources = resources;
        }

        @JsonProperty(value="schemas")
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        @JsonProperty(value="startIndex")
        public void setStartIndex(Integer startIndex) {
            this.startIndex = startIndex;
        }

        @JsonProperty(value="totalResults")
        public void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public Integer getItemsPerPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Group> getResources() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStartIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTotalResults() {
            throw new UnsupportedOperationException();
        }
    }
}

