/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients.ChangeSecret;
import org.cloudfoundry.uaa.clients._BatchChangeSecretRequest;
import org.immutables.value.Generated;

@Generated(from="_BatchChangeSecretRequest", generator="Immutables")
public final class BatchChangeSecretRequest
extends _BatchChangeSecretRequest {
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;
    private final List<ChangeSecret> changeSecrets;

    private BatchChangeSecretRequest(Builder builder) {
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
        this.changeSecrets = BatchChangeSecretRequest.createUnmodifiableList(true, builder.changeSecrets);
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    @Override
    @JsonProperty(value="changeSecrets")
    @JsonIgnore
    public List<ChangeSecret> getChangeSecrets() {
        return this.changeSecrets;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BatchChangeSecretRequest && this.equalTo((BatchChangeSecretRequest)another);
    }

    private boolean equalTo(BatchChangeSecretRequest another) {
        return Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain) && this.changeSecrets.equals(another.changeSecrets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        h += (h << 5) + this.changeSecrets.hashCode();
        return h;
    }

    public String toString() {
        return "BatchChangeSecretRequest{identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + ", changeSecrets=" + this.changeSecrets + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BatchChangeSecretRequest fromJson(Json json) {
        Builder builder = BatchChangeSecretRequest.builder();
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        if (json.changeSecrets != null) {
            builder.addAllChangeSecrets(json.changeSecrets);
        }
        return builder.build();
    }

    private static BatchChangeSecretRequest validate(BatchChangeSecretRequest instance) {
        instance.checkClients();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_BatchChangeSecretRequest", generator="Immutables")
    public static final class Builder {
        private String identityZoneId;
        private String identityZoneSubdomain;
        private List<ChangeSecret> changeSecrets = new ArrayList<ChangeSecret>();

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BatchChangeSecretRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_BatchChangeSecretRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _BatchChangeSecretRequest) {
                instance = (_BatchChangeSecretRequest)object;
                this.addAllChangeSecrets(((_BatchChangeSecretRequest)instance).getChangeSecrets());
            }
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public final Builder changeSecret(ChangeSecret element) {
            this.changeSecrets.add(Objects.requireNonNull(element, "changeSecrets element"));
            return this;
        }

        public final Builder changeSecrets(ChangeSecret ... elements) {
            for (ChangeSecret element : elements) {
                this.changeSecrets.add(Objects.requireNonNull(element, "changeSecrets element"));
            }
            return this;
        }

        public final Builder changeSecrets(Iterable<? extends ChangeSecret> elements) {
            this.changeSecrets.clear();
            return this.addAllChangeSecrets(elements);
        }

        public final Builder addAllChangeSecrets(Iterable<? extends ChangeSecret> elements) {
            for (ChangeSecret changeSecret : elements) {
                this.changeSecrets.add(Objects.requireNonNull(changeSecret, "changeSecrets element"));
            }
            return this;
        }

        public BatchChangeSecretRequest build() {
            return BatchChangeSecretRequest.validate(new BatchChangeSecretRequest(this));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_BatchChangeSecretRequest", generator="Immutables")
    static final class Json
    extends _BatchChangeSecretRequest {
        String identityZoneId;
        String identityZoneSubdomain;
        List<ChangeSecret> changeSecrets = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @JsonProperty(value="changeSecrets")
        @JsonIgnore
        public void setChangeSecrets(List<ChangeSecret> changeSecrets) {
            this.changeSecrets = changeSecrets;
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ChangeSecret> getChangeSecrets() {
            throw new UnsupportedOperationException();
        }
    }
}

