/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.AllowNulls;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.doppler.ContainerMetric;
import org.cloudfoundry.doppler.CounterEvent;
import org.cloudfoundry.doppler.Envelope;
import org.cloudfoundry.doppler.Error;
import org.cloudfoundry.doppler.EventType;
import org.cloudfoundry.doppler.HttpStartStop;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.doppler.ValueMetric;
import org.immutables.value.Value;

@Value.Immutable
abstract class _Envelope {
    _Envelope() {
    }

    public static Envelope from(org.cloudfoundry.dropsonde.events.Envelope dropsonde) {
        Objects.requireNonNull(dropsonde, "dropsonde");
        Envelope.Builder envelope = Envelope.builder().deployment(dropsonde.deployment).eventType(EventType.from(dropsonde.eventType)).index(dropsonde.index).ip(dropsonde.ip).job(dropsonde.job).origin(dropsonde.origin).tags(dropsonde.tags).timestamp(dropsonde.timestamp);
        Optional.ofNullable(dropsonde.containerMetric).ifPresent(d -> envelope.containerMetric(ContainerMetric.from(d)));
        Optional.ofNullable(dropsonde.counterEvent).ifPresent(d -> envelope.counterEvent(CounterEvent.from(d)));
        Optional.ofNullable(dropsonde.error).ifPresent(d -> envelope.error(Error.from(d)));
        Optional.ofNullable(dropsonde.httpStartStop).ifPresent(d -> envelope.httpStartStop(HttpStartStop.from(d)));
        Optional.ofNullable(dropsonde.logMessage).ifPresent(d -> envelope.logMessage(LogMessage.from(d)));
        Optional.ofNullable(dropsonde.valueMetric).ifPresent(d -> envelope.valueMetric(ValueMetric.from(d)));
        return envelope.build();
    }

    @Nullable
    abstract ContainerMetric getContainerMetric();

    @Nullable
    abstract CounterEvent getCounterEvent();

    @Nullable
    abstract String getDeployment();

    @Nullable
    abstract Error getError();

    abstract EventType getEventType();

    @Nullable
    abstract HttpStartStop getHttpStartStop();

    @Nullable
    abstract String getIndex();

    @Nullable
    abstract String getIp();

    @Nullable
    abstract String getJob();

    @Nullable
    abstract LogMessage getLogMessage();

    abstract String getOrigin();

    @AllowNulls
    abstract Map<String, String> getTags();

    @Nullable
    abstract Long getTimestamp();

    @Nullable
    abstract ValueMetric getValueMetric();
}

