/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.stacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.stacks._CreateStackRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateStackRequest", generator="Immutables")
public final class CreateStackRequest
extends _CreateStackRequest {
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final Metadata metadata;

    private CreateStackRequest(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateStackRequest && this.equalTo((CreateStackRequest)another);
    }

    private boolean equalTo(CreateStackRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "CreateStackRequest{name=" + this.name + ", description=" + this.description + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateStackRequest fromJson(Json json) {
        Builder builder = CreateStackRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    private static CreateStackRequest validate(CreateStackRequest instance) {
        instance.validateDescription();
        instance.validateName();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CreateStackRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String description;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(CreateStackRequest instance) {
            return this.from((_CreateStackRequest)instance);
        }

        final Builder from(_CreateStackRequest instance) {
            Metadata metadataValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public CreateStackRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CreateStackRequest.validate(new CreateStackRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateStackRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateStackRequest", generator="Immutables")
    static final class Json
    extends _CreateStackRequest {
        String name;
        String description;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

