/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebrokers;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v3.servicebrokers._BasicAuthentication;
import org.immutables.value.Generated;

@Generated(from="_BasicAuthentication", generator="Immutables")
public final class BasicAuthentication
extends _BasicAuthentication {
    private final String username;
    private final String password;
    private final transient Map<String, Object> credentials;
    private final transient String type;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private BasicAuthentication(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.credentials = this.initShim.getCredentials();
        this.type = this.initShim.getType();
        this.initShim = null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Map<String, Object> getCredentials() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCredentials() : this.credentials;
    }

    @Override
    public String getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BasicAuthentication && this.equalTo((BasicAuthentication)another);
    }

    private boolean equalTo(BasicAuthentication another) {
        return this.username.equals(another.username) && this.password.equals(another.password) && this.credentials.equals(another.credentials) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "BasicAuthentication{username=" + this.username + ", password=" + this.password + ", credentials=" + this.credentials + ", type=" + this.type + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_BasicAuthentication", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private long initBits = 3L;
        private String username;
        private String password;

        private Builder() {
        }

        public final Builder from(BasicAuthentication instance) {
            return this.from((_BasicAuthentication)instance);
        }

        final Builder from(_BasicAuthentication instance) {
            Objects.requireNonNull(instance, "instance");
            this.username(instance.getUsername());
            this.password(instance.getPassword());
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BasicAuthentication build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BasicAuthentication(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build BasicAuthentication, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_BasicAuthentication", generator="Immutables")
    private final class InitShim {
        private byte credentialsBuildStage = 0;
        private Map<String, Object> credentials;
        private byte typeBuildStage = 0;
        private String type;

        private InitShim() {
        }

        Map<String, Object> getCredentials() {
            if (this.credentialsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.credentialsBuildStage == 0) {
                this.credentialsBuildStage = (byte)-1;
                this.credentials = Objects.requireNonNull(BasicAuthentication.super.getCredentials(), "credentials");
                this.credentialsBuildStage = 1;
            }
            return this.credentials;
        }

        String getType() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                this.type = Objects.requireNonNull(BasicAuthentication.super.getType(), "type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.credentialsBuildStage == -1) {
                attributes.add("credentials");
            }
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            return "Cannot build BasicAuthentication, attribute initializers form cycle " + attributes;
        }
    }
}

