/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.packages._UploadPackageRequest;
import org.cloudfoundry.client.v3.resourcematch.MatchedResource;
import org.immutables.value.Generated;

@Generated(from="_UploadPackageRequest", generator="Immutables")
public final class UploadPackageRequest
extends _UploadPackageRequest {
    @Nullable
    private final List<MatchedResource> resources;
    @Nullable
    private final Path bits;
    private final String packageId;

    private UploadPackageRequest(Builder builder) {
        this.resources = builder.resources == null ? null : UploadPackageRequest.createUnmodifiableList(true, builder.resources);
        this.bits = builder.bits;
        this.packageId = builder.packageId;
    }

    @Override
    @Nullable
    public List<MatchedResource> getResources() {
        return this.resources;
    }

    @Override
    @Nullable
    public Path getBits() {
        return this.bits;
    }

    @Override
    public String getPackageId() {
        return this.packageId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UploadPackageRequest && this.equalTo((UploadPackageRequest)another);
    }

    private boolean equalTo(UploadPackageRequest another) {
        return Objects.equals(this.resources, another.resources) && Objects.equals(this.bits, another.bits) && this.packageId.equals(another.packageId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.resources);
        h += (h << 5) + Objects.hashCode(this.bits);
        h += (h << 5) + this.packageId.hashCode();
        return h;
    }

    public String toString() {
        return "UploadPackageRequest{resources=" + this.resources + ", bits=" + this.bits + ", packageId=" + this.packageId + "}";
    }

    private static UploadPackageRequest validate(UploadPackageRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_UploadPackageRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PACKAGE_ID = 1L;
        private long initBits = 1L;
        private List<MatchedResource> resources = null;
        private Path bits;
        private String packageId;

        private Builder() {
        }

        public final Builder from(UploadPackageRequest instance) {
            return this.from((_UploadPackageRequest)instance);
        }

        final Builder from(_UploadPackageRequest instance) {
            Path bitsValue;
            Objects.requireNonNull(instance, "instance");
            List<MatchedResource> resourcesValue = instance.getResources();
            if (resourcesValue != null) {
                this.addAllResources(resourcesValue);
            }
            if ((bitsValue = instance.getBits()) != null) {
                this.bits(bitsValue);
            }
            this.packageId(instance.getPackageId());
            return this;
        }

        public final Builder resource(MatchedResource element) {
            if (this.resources == null) {
                this.resources = new ArrayList<MatchedResource>();
            }
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resources(MatchedResource ... elements) {
            if (this.resources == null) {
                this.resources = new ArrayList<MatchedResource>();
            }
            for (MatchedResource element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        public final Builder resources(@Nullable Iterable<? extends MatchedResource> elements) {
            if (elements == null) {
                this.resources = null;
                return this;
            }
            this.resources = new ArrayList<MatchedResource>();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends MatchedResource> elements) {
            Objects.requireNonNull(elements, "resources element");
            if (this.resources == null) {
                this.resources = new ArrayList<MatchedResource>();
            }
            for (MatchedResource matchedResource : elements) {
                this.resources.add(Objects.requireNonNull(matchedResource, "resources element"));
            }
            return this;
        }

        public final Builder bits(@Nullable Path bits) {
            this.bits = bits;
            return this;
        }

        public final Builder packageId(String packageId) {
            this.packageId = Objects.requireNonNull(packageId, "packageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public UploadPackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return UploadPackageRequest.validate(new UploadPackageRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("packageId");
            }
            return "Cannot build UploadPackageRequest, some of required attributes are not set " + attributes;
        }
    }
}

