/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.auditevents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.auditevents._ListAuditEventsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListAuditEventsRequest", generator="Immutables")
public final class ListAuditEventsRequest
extends _ListAuditEventsRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> organizationIds;
    private final List<String> spaceIds;
    private final List<String> targetIds;
    private final List<String> types;

    private ListAuditEventsRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.organizationIds = ListAuditEventsRequest.createUnmodifiableList(true, builder.organizationIds);
        this.spaceIds = ListAuditEventsRequest.createUnmodifiableList(true, builder.spaceIds);
        this.targetIds = ListAuditEventsRequest.createUnmodifiableList(true, builder.targetIds);
        this.types = ListAuditEventsRequest.createUnmodifiableList(true, builder.types);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    public List<String> getTargetIds() {
        return this.targetIds;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListAuditEventsRequest && this.equalTo((ListAuditEventsRequest)another);
    }

    private boolean equalTo(ListAuditEventsRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.organizationIds.equals(another.organizationIds) && this.spaceIds.equals(another.spaceIds) && this.targetIds.equals(another.targetIds) && this.types.equals(another.types);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.organizationIds.hashCode();
        h += (h << 5) + this.spaceIds.hashCode();
        h += (h << 5) + this.targetIds.hashCode();
        h += (h << 5) + this.types.hashCode();
        return h;
    }

    public String toString() {
        return "ListAuditEventsRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ", targetIds=" + this.targetIds + ", types=" + this.types + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListAuditEventsRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> organizationIds = new ArrayList<String>();
        private List<String> spaceIds = new ArrayList<String>();
        private List<String> targetIds = new ArrayList<String>();
        private List<String> types = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListAuditEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListAuditEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListAuditEventsRequest) {
                instance = (_ListAuditEventsRequest)object;
                this.addAllTypes(((_ListAuditEventsRequest)instance).getTypes());
                this.addAllSpaceIds(((_ListAuditEventsRequest)instance).getSpaceIds());
                this.addAllOrganizationIds(((_ListAuditEventsRequest)instance).getOrganizationIds());
                this.addAllTargetIds(((_ListAuditEventsRequest)instance).getTargetIds());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder targetId(String element) {
            this.targetIds.add(Objects.requireNonNull(element, "targetIds element"));
            return this;
        }

        public final Builder targetIds(String ... elements) {
            for (String element : elements) {
                this.targetIds.add(Objects.requireNonNull(element, "targetIds element"));
            }
            return this;
        }

        public final Builder targetIds(Iterable<String> elements) {
            this.targetIds.clear();
            return this.addAllTargetIds(elements);
        }

        public final Builder addAllTargetIds(Iterable<String> elements) {
            for (String element : elements) {
                this.targetIds.add(Objects.requireNonNull(element, "targetIds element"));
            }
            return this;
        }

        public final Builder type(String element) {
            this.types.add(Objects.requireNonNull(element, "types element"));
            return this;
        }

        public final Builder types(String ... elements) {
            for (String element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public final Builder types(Iterable<String> elements) {
            this.types.clear();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<String> elements) {
            for (String element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public ListAuditEventsRequest build() {
            return new ListAuditEventsRequest(this);
        }
    }
}

