/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.webui.reporting;

import com.mendix.systemwideinterfaces.MendixRuntimeException;
import com.mendix.webui.reporting.ColumnType;
import com.mendix.webui.reporting.IDataSetResult;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class DataSetResult
implements IDataSetResult {
    private final LinkedHashMap<String, Object> columns;
    private List<ColumnType> columnTypes;
    private final LinkedHashMap<String, List<Object>> data;
    private long totalResultCount;

    public DataSetResult(LinkedHashMap<String, Object> linkedHashMap) {
        this.columns = linkedHashMap;
        this.data = new LinkedHashMap();
    }

    @Override
    public void setColumnValues(String string, List<Object> list) {
        this.data.put(string, list);
    }

    @Override
    public void addRow(Object ... objectArray) {
        if (objectArray == null) {
            throw new MendixRuntimeException("No valid values.");
        }
        if (this.columns != null && this.columns.size() != objectArray.length) {
            throw new MendixRuntimeException("Count of columns does not match the column configuration. There are " + this.columns.size() + " columns configurated, but the dataset returns " + objectArray.length + " columns.");
        }
        if (this.data.size() == 0 && objectArray.length > 0) {
            for (String iterator : this.columns.keySet()) {
                this.data.put(iterator, new ArrayList());
            }
        } else {
            Object object = null;
            for (List<Object> list : this.data.values()) {
                if (list == null) {
                    throw new MendixRuntimeException("There is a column with zero rows.");
                }
                if (object != null && object.size() != list.size()) {
                    throw new MendixRuntimeException("There are columns which don't have the same size.");
                }
                object = list;
            }
        }
        int n = 0;
        for (List<Object> list : this.data.values()) {
            list.add(objectArray[n++]);
        }
    }

    public List<Object> getData(String string) {
        return this.data.get(string);
    }

    public LinkedHashMap<String, Object> getColumns() {
        return this.columns;
    }

    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    public void addColumnType(ColumnType columnType) {
        if (this.columnTypes == null) {
            this.columnTypes = new ArrayList<ColumnType>();
        }
        this.columnTypes.add(columnType);
    }

    public long getTotalResultCount() {
        return this.totalResultCount;
    }

    @Override
    public void setTotalResultCount(long l) {
        this.totalResultCount = l;
    }
}

