/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.webui.reporting;

import com.mendix.systemwideinterfaces.core.meta.IMetaPrimitive;
import com.mendix.webui.reporting.DateTimeFormat;
import com.mendix.webui.reporting.EnumType;
import java.math.BigDecimal;
import java.util.Date;

public class ColumnType {
    private IMetaPrimitive metaPrimitive;
    private IMetaPrimitive.PrimitiveType primitiveType;
    private EnumType enumType;
    private DateTimeFormat dateTimeFormat;

    public ColumnType(IMetaPrimitive iMetaPrimitive) {
        this.metaPrimitive = iMetaPrimitive;
        this.primitiveType = iMetaPrimitive.getType();
    }

    public ColumnType(IMetaPrimitive.PrimitiveType primitiveType) {
        this.primitiveType = primitiveType;
    }

    public ColumnType(EnumType enumType) {
        this.enumType = enumType;
        this.primitiveType = IMetaPrimitive.PrimitiveType.Enum;
    }

    public ColumnType(DateTimeFormat dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        this.primitiveType = IMetaPrimitive.PrimitiveType.DateTime;
    }

    public ColumnType(Class<?> clazz) {
        if (String.class.equals(clazz)) {
            this.primitiveType = IMetaPrimitive.PrimitiveType.String;
        } else if (Boolean.class.equals(clazz)) {
            this.primitiveType = IMetaPrimitive.PrimitiveType.Boolean;
        } else if (Date.class.isAssignableFrom(clazz)) {
            this.primitiveType = IMetaPrimitive.PrimitiveType.DateTime;
        } else if (Integer.class.equals(clazz) || Short.class.equals(clazz) || Byte.class.equals(clazz)) {
            this.primitiveType = IMetaPrimitive.PrimitiveType.Integer;
        } else if (Long.class.equals(clazz)) {
            this.primitiveType = IMetaPrimitive.PrimitiveType.Long;
        } else if (BigDecimal.class.equals(clazz)) {
            this.primitiveType = IMetaPrimitive.PrimitiveType.Decimal;
        }
    }

    public IMetaPrimitive getMetaPrimitive() {
        return this.metaPrimitive;
    }

    public IMetaPrimitive.PrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    public EnumType getEnumType() {
        return this.enumType;
    }

    public DateTimeFormat getColumnFormat() {
        return this.dateTimeFormat;
    }
}

