/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.mlkit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Base64;
import java.util.function.BiConsumer;

public final class MLKit {
    private static final BiConsumer<Object, ByteBuffer> BYTE_PRIMITIVE_CONSUMER = (object, byteBuffer) -> {
        for (byte by : (byte[])object) {
            byteBuffer.put(by);
        }
    };
    private static final BiConsumer<Object, ByteBuffer> SHORT_PRIMITIVE_CONSUMER = (object, byteBuffer) -> {
        for (short s : (short[])object) {
            byteBuffer.putShort(s);
        }
    };
    private static final BiConsumer<Object, ByteBuffer> INT_PRIMITIVE_CONSUMER = (object, byteBuffer) -> {
        for (int n : (int[])object) {
            byteBuffer.putInt(n);
        }
    };
    private static final BiConsumer<Object, ByteBuffer> LONG_PRIMITIVE_CONSUMER = (object, byteBuffer) -> {
        for (long l : (long[])object) {
            byteBuffer.putLong(l);
        }
    };
    private static final BiConsumer<Object, ByteBuffer> FLOAT_PRIMITIVE_CONSUMER = (object, byteBuffer) -> {
        for (float f : (float[])object) {
            byteBuffer.putFloat(f);
        }
    };
    private static final BiConsumer<Object, ByteBuffer> DOUBLE_PRIMITIVE_CONSUMER = (object, byteBuffer) -> {
        for (double d : (double[])object) {
            byteBuffer.putDouble(d);
        }
    };

    public static void toArray(InputStream inputStream, byte[] byArray) {
        MLKit.reshape(MLKit.toByteArray(inputStream), new byte[][]{byArray});
    }

    public static void toArray(InputStream inputStream, byte[][] byArray) {
        MLKit.reshape(MLKit.toByteArray(inputStream), byArray);
    }

    public static void toArray(InputStream inputStream, byte[][][] byArray) {
        MLKit.reshape(MLKit.toByteArray(inputStream), byArray);
    }

    public static void toArray(InputStream inputStream, byte[][][][] byArray) {
        MLKit.reshape(MLKit.toByteArray(inputStream), byArray);
    }

    public static void toArray(InputStream inputStream, byte[][][][][] byArray) {
        MLKit.reshape(MLKit.toByteArray(inputStream), byArray);
    }

    public static void toArray(InputStream inputStream, byte[][][][][][] byArray) {
        MLKit.reshape(MLKit.toByteArray(inputStream), byArray);
    }

    public static void toArray(InputStream inputStream, byte[][][][][][][] byArray) {
        MLKit.reshape(MLKit.toByteArray(inputStream), byArray);
    }

    public static void toArray(InputStream inputStream, byte[][][][][][][][] byArray) {
        MLKit.reshape(MLKit.toByteArray(inputStream), byArray);
    }

    public static void toArray(InputStream inputStream, short[] sArray) throws IOException {
        MLKit.reshape(MLKit.toShortArray(inputStream), new short[][]{sArray});
    }

    public static void toArray(InputStream inputStream, short[][] sArray) {
        MLKit.reshape(MLKit.toShortArray(inputStream), sArray);
    }

    public static void toArray(InputStream inputStream, short[][][] sArray) {
        MLKit.reshape(MLKit.toShortArray(inputStream), sArray);
    }

    public static void toArray(InputStream inputStream, short[][][][] sArray) {
        MLKit.reshape(MLKit.toShortArray(inputStream), sArray);
    }

    public static void toArray(InputStream inputStream, short[][][][][] sArray) {
        MLKit.reshape(MLKit.toShortArray(inputStream), sArray);
    }

    public static void toArray(InputStream inputStream, short[][][][][][] sArray) {
        MLKit.reshape(MLKit.toShortArray(inputStream), sArray);
    }

    public static void toArray(InputStream inputStream, short[][][][][][][] sArray) {
        MLKit.reshape(MLKit.toShortArray(inputStream), sArray);
    }

    public static void toArray(InputStream inputStream, short[][][][][][][][] sArray) {
        MLKit.reshape(MLKit.toShortArray(inputStream), sArray);
    }

    public static void toArray(InputStream inputStream, int[] nArray) {
        MLKit.reshape(MLKit.toIntArray(inputStream), new int[][]{nArray});
    }

    public static void toArray(InputStream inputStream, int[][] nArray) {
        MLKit.reshape(MLKit.toIntArray(inputStream), nArray);
    }

    public static void toArray(InputStream inputStream, int[][][] nArray) {
        MLKit.reshape(MLKit.toIntArray(inputStream), nArray);
    }

    public static void toArray(InputStream inputStream, int[][][][] nArray) {
        MLKit.reshape(MLKit.toIntArray(inputStream), nArray);
    }

    public static void toArray(InputStream inputStream, int[][][][][] nArray) {
        MLKit.reshape(MLKit.toIntArray(inputStream), nArray);
    }

    public static void toArray(InputStream inputStream, int[][][][][][] nArray) {
        MLKit.reshape(MLKit.toIntArray(inputStream), nArray);
    }

    public static void toArray(InputStream inputStream, int[][][][][][][] nArray) {
        MLKit.reshape(MLKit.toIntArray(inputStream), nArray);
    }

    public static void toArray(InputStream inputStream, int[][][][][][][][] nArray) {
        MLKit.reshape(MLKit.toIntArray(inputStream), nArray);
    }

    public static void toArray(InputStream inputStream, long[] lArray) {
        MLKit.reshape(MLKit.toLongArray(inputStream), new long[][]{lArray});
    }

    public static void toArray(InputStream inputStream, long[][] lArray) {
        MLKit.reshape(MLKit.toLongArray(inputStream), lArray);
    }

    public static void toArray(InputStream inputStream, long[][][] lArray) {
        MLKit.reshape(MLKit.toLongArray(inputStream), lArray);
    }

    public static void toArray(InputStream inputStream, long[][][][] lArray) {
        MLKit.reshape(MLKit.toLongArray(inputStream), lArray);
    }

    public static void toArray(InputStream inputStream, long[][][][][] lArray) {
        MLKit.reshape(MLKit.toLongArray(inputStream), lArray);
    }

    public static void toArray(InputStream inputStream, long[][][][][][] lArray) {
        MLKit.reshape(MLKit.toLongArray(inputStream), lArray);
    }

    public static void toArray(InputStream inputStream, long[][][][][][][] lArray) {
        MLKit.reshape(MLKit.toLongArray(inputStream), lArray);
    }

    public static void toArray(InputStream inputStream, long[][][][][][][][] lArray) {
        MLKit.reshape(MLKit.toLongArray(inputStream), lArray);
    }

    public static void toArray(InputStream inputStream, float[] fArray) {
        MLKit.reshape(MLKit.toFloatArray(inputStream), new float[][]{fArray});
    }

    public static void toArray(InputStream inputStream, float[][] fArray) {
        MLKit.reshape(MLKit.toFloatArray(inputStream), fArray);
    }

    public static void toArray(InputStream inputStream, float[][][] fArray) {
        MLKit.reshape(MLKit.toFloatArray(inputStream), fArray);
    }

    public static void toArray(InputStream inputStream, float[][][][] fArray) {
        MLKit.reshape(MLKit.toFloatArray(inputStream), fArray);
    }

    public static void toArray(InputStream inputStream, float[][][][][] fArray) {
        MLKit.reshape(MLKit.toFloatArray(inputStream), fArray);
    }

    public static void toArray(InputStream inputStream, float[][][][][][] fArray) {
        MLKit.reshape(MLKit.toFloatArray(inputStream), fArray);
    }

    public static void toArray(InputStream inputStream, float[][][][][][][] fArray) {
        MLKit.reshape(MLKit.toFloatArray(inputStream), fArray);
    }

    public static void toArray(InputStream inputStream, float[][][][][][][][] fArray) {
        MLKit.reshape(MLKit.toFloatArray(inputStream), fArray);
    }

    public static void toArray(InputStream inputStream, double[] dArray) {
        MLKit.reshape(MLKit.toDoubleArray(inputStream), new double[][]{dArray});
    }

    public static void toArray(InputStream inputStream, double[][] dArray) {
        MLKit.reshape(MLKit.toDoubleArray(inputStream), dArray);
    }

    public static void toArray(InputStream inputStream, double[][][] dArray) {
        MLKit.reshape(MLKit.toDoubleArray(inputStream), dArray);
    }

    public static void toArray(InputStream inputStream, double[][][][] dArray) {
        MLKit.reshape(MLKit.toDoubleArray(inputStream), dArray);
    }

    public static void toArray(InputStream inputStream, double[][][][][] dArray) {
        MLKit.reshape(MLKit.toDoubleArray(inputStream), dArray);
    }

    public static void toArray(InputStream inputStream, double[][][][][][] dArray) {
        MLKit.reshape(MLKit.toDoubleArray(inputStream), dArray);
    }

    public static void toArray(InputStream inputStream, double[][][][][][][] dArray) {
        MLKit.reshape(MLKit.toDoubleArray(inputStream), dArray);
    }

    public static void toArray(InputStream inputStream, double[][][][][][][][] dArray) {
        MLKit.reshape(MLKit.toDoubleArray(inputStream), dArray);
    }

    public static InputStream toInputStream(byte[] byArray) {
        return MLKit.toInputStream(byArray, BYTE_PRIMITIVE_CONSUMER, 1);
    }

    public static InputStream toInputStream(byte[][] byArray) {
        return MLKit.toInputStream(byArray, BYTE_PRIMITIVE_CONSUMER, 1);
    }

    public static InputStream toInputStream(byte[][][] byArray) {
        return MLKit.toInputStream(byArray, BYTE_PRIMITIVE_CONSUMER, 1);
    }

    public static InputStream toInputStream(byte[][][][] byArray) {
        return MLKit.toInputStream(byArray, BYTE_PRIMITIVE_CONSUMER, 1);
    }

    public static InputStream toInputStream(byte[][][][][] byArray) {
        return MLKit.toInputStream(byArray, BYTE_PRIMITIVE_CONSUMER, 1);
    }

    public static InputStream toInputStream(byte[][][][][][] byArray) {
        return MLKit.toInputStream(byArray, BYTE_PRIMITIVE_CONSUMER, 1);
    }

    public static InputStream toInputStream(byte[][][][][][][] byArray) {
        return MLKit.toInputStream(byArray, BYTE_PRIMITIVE_CONSUMER, 1);
    }

    public static InputStream toInputStream(byte[][][][][][][][] byArray) {
        return MLKit.toInputStream(byArray, BYTE_PRIMITIVE_CONSUMER, 1);
    }

    public static InputStream toInputStream(short[] sArray) {
        return MLKit.toInputStream(sArray, SHORT_PRIMITIVE_CONSUMER, 2);
    }

    public static InputStream toInputStream(short[][] sArray) {
        return MLKit.toInputStream(sArray, SHORT_PRIMITIVE_CONSUMER, 2);
    }

    public static InputStream toInputStream(short[][][] sArray) {
        return MLKit.toInputStream(sArray, SHORT_PRIMITIVE_CONSUMER, 2);
    }

    public static InputStream toInputStream(short[][][][] sArray) {
        return MLKit.toInputStream(sArray, SHORT_PRIMITIVE_CONSUMER, 2);
    }

    public static InputStream toInputStream(short[][][][][] sArray) {
        return MLKit.toInputStream(sArray, SHORT_PRIMITIVE_CONSUMER, 2);
    }

    public static InputStream toInputStream(short[][][][][][] sArray) {
        return MLKit.toInputStream(sArray, SHORT_PRIMITIVE_CONSUMER, 2);
    }

    public static InputStream toInputStream(short[][][][][][][] sArray) {
        return MLKit.toInputStream(sArray, SHORT_PRIMITIVE_CONSUMER, 2);
    }

    public static InputStream toInputStream(short[][][][][][][][] sArray) {
        return MLKit.toInputStream(sArray, SHORT_PRIMITIVE_CONSUMER, 2);
    }

    public static InputStream toInputStream(int[] nArray) {
        return MLKit.toInputStream(nArray, INT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(int[][] nArray) {
        return MLKit.toInputStream(nArray, INT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(int[][][] nArray) {
        return MLKit.toInputStream(nArray, INT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(int[][][][] nArray) {
        return MLKit.toInputStream(nArray, INT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(int[][][][][] nArray) {
        return MLKit.toInputStream(nArray, INT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(int[][][][][][] nArray) {
        return MLKit.toInputStream(nArray, INT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(int[][][][][][][] nArray) {
        return MLKit.toInputStream(nArray, INT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(int[][][][][][][][] nArray) {
        return MLKit.toInputStream(nArray, INT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(long[] lArray) {
        return MLKit.toInputStream(lArray, LONG_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(long[][] lArray) {
        return MLKit.toInputStream(lArray, LONG_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(long[][][] lArray) {
        return MLKit.toInputStream(lArray, LONG_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(long[][][][] lArray) {
        return MLKit.toInputStream(lArray, LONG_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(long[][][][][] lArray) {
        return MLKit.toInputStream(lArray, LONG_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(long[][][][][][] lArray) {
        return MLKit.toInputStream(lArray, LONG_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(long[][][][][][][] lArray) {
        return MLKit.toInputStream(lArray, LONG_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(long[][][][][][][][] lArray) {
        return MLKit.toInputStream(lArray, LONG_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(float[] fArray) {
        return MLKit.toInputStream(fArray, FLOAT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(float[][] fArray) {
        return MLKit.toInputStream(fArray, FLOAT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(float[][][] fArray) {
        return MLKit.toInputStream(fArray, FLOAT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(float[][][][] fArray) {
        return MLKit.toInputStream(fArray, FLOAT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(float[][][][][] fArray) {
        return MLKit.toInputStream(fArray, FLOAT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(float[][][][][][] fArray) {
        return MLKit.toInputStream(fArray, FLOAT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(float[][][][][][][] fArray) {
        return MLKit.toInputStream(fArray, FLOAT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(float[][][][][][][][] fArray) {
        return MLKit.toInputStream(fArray, FLOAT_PRIMITIVE_CONSUMER, 4);
    }

    public static InputStream toInputStream(double[] dArray) {
        return MLKit.toInputStream(dArray, DOUBLE_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(double[][] dArray) {
        return MLKit.toInputStream(dArray, DOUBLE_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(double[][][] dArray) {
        return MLKit.toInputStream(dArray, DOUBLE_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(double[][][][] dArray) {
        return MLKit.toInputStream(dArray, DOUBLE_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(double[][][][][] dArray) {
        return MLKit.toInputStream(dArray, DOUBLE_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(double[][][][][][] dArray) {
        return MLKit.toInputStream(dArray, DOUBLE_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(double[][][][][][][] dArray) {
        return MLKit.toInputStream(dArray, DOUBLE_PRIMITIVE_CONSUMER, 8);
    }

    public static InputStream toInputStream(double[][][][][][][][] dArray) {
        return MLKit.toInputStream(dArray, DOUBLE_PRIMITIVE_CONSUMER, 8);
    }

    private static InputStream toInputStream(Object object, BiConsumer<Object, ByteBuffer> biConsumer, int n) {
        MLKit.validateArray(object);
        ByteBuffer byteBuffer = MLKit.createByteBuffer(object, n);
        MLKit.collectToBuffer(object, biConsumer, byteBuffer);
        return new ByteArrayInputStream(byteBuffer.array());
    }

    public static String toBase64(InputStream inputStream) {
        try {
            byte[] byArray = MLKit.readAllBytes(inputStream);
            return Base64.getEncoder().encodeToString(byArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to read from InputStream: " + String.valueOf(exception));
        }
    }

    public static InputStream fromBase64(String string) {
        byte[] byArray = Base64.getDecoder().decode(string);
        return new ByteArrayInputStream(byArray);
    }

    private static byte[] toByteArray(InputStream inputStream) {
        try {
            return MLKit.readAllBytes(inputStream);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to read from InputStream: " + String.valueOf(exception));
        }
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static ByteBuffer toByteBuffer(InputStream inputStream) {
        byte[] byArray = MLKit.toByteArray(inputStream);
        return ByteBuffer.wrap(byArray);
    }

    private static short[] toShortArray(InputStream inputStream) {
        ByteBuffer byteBuffer = MLKit.toByteBuffer(inputStream);
        ShortBuffer shortBuffer = ShortBuffer.allocate(byteBuffer.array().length / 2);
        while (byteBuffer.hasRemaining()) {
            shortBuffer.put(byteBuffer.getShort());
        }
        return shortBuffer.array();
    }

    private static int[] toIntArray(InputStream inputStream) {
        ByteBuffer byteBuffer = MLKit.toByteBuffer(inputStream);
        IntBuffer intBuffer = IntBuffer.allocate(byteBuffer.array().length / 4);
        while (byteBuffer.hasRemaining()) {
            intBuffer.put(byteBuffer.getInt());
        }
        return intBuffer.array();
    }

    private static long[] toLongArray(InputStream inputStream) {
        ByteBuffer byteBuffer = MLKit.toByteBuffer(inputStream);
        LongBuffer longBuffer = LongBuffer.allocate(byteBuffer.array().length / 8);
        while (byteBuffer.hasRemaining()) {
            longBuffer.put(byteBuffer.getLong());
        }
        return longBuffer.array();
    }

    private static float[] toFloatArray(InputStream inputStream) {
        ByteBuffer byteBuffer = MLKit.toByteBuffer(inputStream);
        FloatBuffer floatBuffer = FloatBuffer.allocate(byteBuffer.array().length / 4);
        while (byteBuffer.hasRemaining()) {
            floatBuffer.put(byteBuffer.getFloat());
        }
        return floatBuffer.array();
    }

    private static double[] toDoubleArray(InputStream inputStream) {
        ByteBuffer byteBuffer = MLKit.toByteBuffer(inputStream);
        DoubleBuffer doubleBuffer = DoubleBuffer.allocate(byteBuffer.array().length / 8);
        while (byteBuffer.hasRemaining()) {
            doubleBuffer.put(byteBuffer.getDouble());
        }
        return doubleBuffer.array();
    }

    private static void validateArray(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Array is null");
        }
        if (!object.getClass().isArray()) {
            throw new IllegalStateException("Found element type when expecting an array. Class " + String.valueOf(object.getClass()));
        }
    }

    private static ByteBuffer createByteBuffer(Object object, int n) {
        int n2 = n * MLKit.arrayCapacity(object);
        return ByteBuffer.allocate(n2);
    }

    private static int arrayCapacity(Object object) {
        MLKit.validateArray(object);
        if (object.getClass().getComponentType().isPrimitive()) {
            return Array.getLength(object);
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length == 0) {
            throw new IllegalStateException("Unsupported array dimension: 0");
        }
        return objectArray.length * MLKit.arrayCapacity(objectArray[0]);
    }

    private static void collectToBuffer(Object object, BiConsumer<Object, ByteBuffer> biConsumer, ByteBuffer byteBuffer) {
        if (object.getClass().getComponentType().isPrimitive()) {
            biConsumer.accept(object, byteBuffer);
        } else {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])object) {
                MLKit.collectToBuffer(object2, biConsumer, byteBuffer);
            }
        }
    }

    private static void reshape(Object object, Object object2) {
        int n;
        int n2 = MLKit.arrayCapacity(object);
        if (n2 > (n = MLKit.arrayCapacity(object2))) {
            throw new IllegalArgumentException("Total input values: " + n2 + ", provided array capacity: " + n);
        }
        MLKit.reshape(object, object2, 0);
    }

    private static int reshape(Object object, Object object2, int n) {
        MLKit.validateArray(object2);
        for (Object object3 : (Object[])object2) {
            MLKit.validateArray(object3);
            Class<?> clazz = object3.getClass().getComponentType();
            if (clazz.isPrimitive()) {
                int n2 = Array.getLength(object3);
                System.arraycopy(object, n, object3, 0, n2);
                n += n2;
                continue;
            }
            n = MLKit.reshape(object, object3, n);
        }
        return n;
    }
}

