/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.core.objectmanagement;

import com.mendix.systemwideinterfaces.core.meta.IDataValidation;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public class DataValidationInfo {
    private final LinkedHashMap<String, String> errorFields = new LinkedHashMap();
    private final Long guid;
    private final HashMap<String, List<IDataValidation>> failedValidations = new HashMap();

    public DataValidationInfo(Long l) {
        this.guid = l;
    }

    public Long guid() {
        return this.guid;
    }

    public HashMap<String, String> errorFields() {
        return this.errorFields;
    }

    public void addErrorField(String string, String string2) {
        this.errorFields.put(string, string2);
    }

    public void addErrorField(String string, String string2, List<IDataValidation> list) {
        this.errorFields.put(string, string2);
        this.failedValidations.put(string, list);
    }

    public void addErrorField(String string, List<IDataValidation> list) {
        this.failedValidations.put(string, list);
    }

    public HashMap<String, List<IDataValidation>> failedValidations() {
        return this.failedValidations;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.errorFields.forEach((string, string2) -> stringBuilder.append(String.format("(member: %s, message: %s)", string, string2)));
        return String.format("Object id: %d, validation errors: %s", this.guid, stringBuilder);
    }

    public boolean equals(Object object) {
        if (object instanceof DataValidationInfo) {
            DataValidationInfo dataValidationInfo = (DataValidationInfo)object;
            return dataValidationInfo.guid().equals(this.guid) && dataValidationInfo.errorFields.equals(this.errorFields);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.errorFields, this.guid);
    }
}

