/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.core.actionmanagement.internal;

import com.mendix.core.CoreException;
import com.mendix.core.actionmanagement.ActionState;
import com.mendix.core.actionmanagement.internal.ActionHandler;
import com.mendix.core.actionmanagement.internal.CoreActionHandler;
import com.mendix.core.actionmanagement.internal.ICoreActionHandler;
import com.mendix.core.objectmanagement.DataValidationInfo;
import com.mendix.systemwideinterfaces.core.IContext;
import com.mendix.systemwideinterfaces.core.ICoreAction;
import com.mendix.systemwideinterfaces.core.IMendixIdentifier;
import com.mendix.systemwideinterfaces.core.IMendixObject;
import com.mendix.systemwideinterfaces.core.UserException;
import com.mendix.thirdparty.org.json.JSONObject;
import java.util.List;
import java.util.Map;

public abstract class InternalCoreAction<R>
implements ICoreAction<R> {
    private CoreActionHandler handler;

    public InternalCoreAction(IContext iContext) {
        this.handler = ActionHandler.createCoreHandler(iContext);
    }

    public InternalCoreAction(CoreActionHandler coreActionHandler) {
        this.handler = coreActionHandler;
    }

    public ICoreActionHandler getHandler() {
        return this.handler;
    }

    @Override
    public IContext getContext() {
        return this.handler.getContext();
    }

    @Deprecated
    public void setContext(IContext iContext) {
        this.handler.setContext(iContext);
    }

    public abstract R execute() throws Exception;

    @Override
    public R call() {
        return this.handler.call(this);
    }

    @Deprecated
    public void addDatavalidationFeedback(IMendixIdentifier iMendixIdentifier, Map<String, String> map) {
        DataValidationInfo dataValidationInfo = new DataValidationInfo(iMendixIdentifier.toLong());
        map.forEach(dataValidationInfo::addErrorField);
        this.getContext().addDataValidation(dataValidationInfo);
    }

    @Deprecated
    public void addDataValidationFeedback(DataValidationInfo dataValidationInfo) {
        this.getContext().addDataValidation(dataValidationInfo);
    }

    @Deprecated
    public void handleConcurrentExecution() throws UserException, CoreException {
        throw new UserException(UserException.ExceptionCategory.Custom, String.format("Action '%s' was skipped as it does not allow concurrent execution", this.getActionName()));
    }

    @Override
    public List<IMendixObject> getEventObjects() {
        return this.handler.getEventObjects();
    }

    @Deprecated
    public void setEventObjects(List<IMendixObject> list) {
        this.handler.setEventObjects(list);
    }

    @Override
    public String getMetaInfoJsonString() {
        return this.handler.getMetaInfo().toString();
    }

    @Deprecated
    public void setMetaInfo(JSONObject jSONObject) {
        this.handler.setMetaInfo(jSONObject);
    }

    @Override
    public String getActionName() {
        return this.handler.getActionName();
    }

    @Deprecated
    public void setActionName(String string) {
        this.handler.setActionName(string);
    }

    @Deprecated
    public Exception getException() {
        return this.handler.getException();
    }

    @Deprecated
    public void setException(Exception exception) {
        this.handler.setException(exception);
    }

    @Deprecated
    public ActionState getState() {
        return this.handler.getState();
    }

    @Deprecated
    public void setState(ActionState actionState) {
        this.handler.setState(actionState);
    }

    @Deprecated
    public void setAllowsConcurrentExecution(Boolean bl) {
        this.handler.setAllowsConcurrentExecution(bl);
    }

    @Deprecated
    public IContext getClonedContext(IMendixIdentifier iMendixIdentifier, List<IMendixIdentifier> list) {
        return this.handler.getClonedContext(iMendixIdentifier, list);
    }

    @Deprecated
    public InternalCoreAction<R> clone() {
        try {
            InternalCoreAction internalCoreAction = (InternalCoreAction)super.clone();
            internalCoreAction.handler = this.handler.createClone();
            return internalCoreAction;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

