/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.core.actionmanagement.internal;

import com.mendix.core.actionmanagement.internal.CoreActionHandler;
import com.mendix.core.actionmanagement.internal.HandlerFactory;
import com.mendix.core.actionmanagement.internal.LoginActionHandler;
import com.mendix.systemwideinterfaces.core.IContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ActionHandler {
    private static final ThreadLocal<HandlerFactory> fallbackHandlerFactory = new ThreadLocal();
    public static final ConcurrentHashMap<String, HandlerFactory> handlerFactories = new ConcurrentHashMap(1, 1.0f);

    public static CoreActionHandler createCoreHandler(IContext iContext) {
        return ActionHandler.handlerFactory(iContext).createCoreActionHandler(iContext);
    }

    public static LoginActionHandler createLoginHandler(IContext iContext, Map<String, ? extends Object> map) {
        return ActionHandler.handlerFactory(iContext).createLoginActionHandler(iContext, map);
    }

    public static String convertToActionName(String string) {
        return string.replaceFirst("\\.actions\\.", ".");
    }

    @Deprecated
    public static void setHandlerFactory(HandlerFactory handlerFactory) {
        fallbackHandlerFactory.set(handlerFactory);
    }

    private static HandlerFactory handlerFactory(IContext iContext) {
        String string = iContext.getSystemConfiguration().getXASId();
        if (string != null && handlerFactories.containsKey(string)) {
            return handlerFactories.get(string);
        }
        if (fallbackHandlerFactory.get() != null) {
            return fallbackHandlerFactory.get();
        }
        throw new IllegalStateException("ActionHandlerComponent not wired!");
    }
}

