/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.core.actionmanagement;

import com.mendix.core.actionmanagement.EventActionInfo;
import com.mendix.core.actionmanagement.internal.ActionHandler;
import com.mendix.systemwideinterfaces.MendixRuntimeException;
import com.mendix.systemwideinterfaces.core.ICoreAction;
import com.mendix.systemwideinterfaces.core.IMendixObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class ActionListener<T extends ICoreAction<?>>
implements Cloneable {
    private final Class<T> targetClass;
    private final List<EventActionInfo> before = new ArrayList<EventActionInfo>();
    private final List<EventActionInfo> after = new ArrayList<EventActionInfo>();
    private String replace = null;

    public ActionListener(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Target class should not be null");
        }
        this.targetClass = clazz;
    }

    public final Class<T> getTargetClass() {
        return this.targetClass;
    }

    private String validateAndConvertToActionName(String string) {
        return ActionHandler.convertToActionName(string);
    }

    public final void addBeforeEvent(String string) {
        this.addBeforeEvent(string, false);
    }

    public final void addBeforeEvent(Consumer<IMendixObject> consumer, boolean bl) {
        this.before.add(new EventActionInfo(consumer, bl));
    }

    public final void addBeforeEvent(String string, boolean bl) {
        this.before.add(new EventActionInfo(this.validateAndConvertToActionName(string), bl));
    }

    public final void addAfterEvent(String string) {
        this.after.add(new EventActionInfo(this.validateAndConvertToActionName(string), false));
    }

    public final void addAfterEvent(Consumer<IMendixObject> consumer) {
        this.after.add(new EventActionInfo(consumer));
    }

    @Deprecated
    public final void addReplaceEvent(String string) {
        this.setReplaceEvent(string);
    }

    public final void setReplaceEvent(String string) {
        this.replace = this.validateAndConvertToActionName(string);
    }

    public final List<EventActionInfo> getAfter() {
        return this.after;
    }

    public final List<EventActionInfo> getBefore() {
        return this.before;
    }

    public final String getReplace() {
        return this.replace;
    }

    public abstract boolean check(T var1);

    @Deprecated
    public ActionListener<T> createClone() {
        try {
            return (ActionListener)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new MendixRuntimeException(cloneNotSupportedException);
        }
    }
}

