/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.Action;
import org.gradle.api.internal.AbstractMutationGuard;

public class DefaultMutationGuard
extends AbstractMutationGuard {
    private final ThreadLocal<Boolean> mutationGuardState = new GuardState();

    @Override
    public boolean isMutationAllowed() {
        boolean mutationAllowed = this.mutationGuardState.get();
        this.removeThreadLocalStateIfMutationAllowed(mutationAllowed);
        return mutationAllowed;
    }

    @Override
    protected <T> Action<? super T> newActionWithMutation(final Action<? super T> action, final boolean allowMutationMethods) {
        return new Action<T>(){

            public void execute(T t) {
                boolean oldIsMutationAllowed = (Boolean)DefaultMutationGuard.this.mutationGuardState.get();
                DefaultMutationGuard.this.mutationGuardState.set(allowMutationMethods);
                try {
                    action.execute(t);
                }
                finally {
                    DefaultMutationGuard.this.setMutationGuardState(oldIsMutationAllowed);
                }
            }
        };
    }

    private void setMutationGuardState(boolean newState) {
        if (newState) {
            this.removeThreadLocalStateIfMutationAllowed(true);
        } else {
            this.mutationGuardState.set(false);
        }
    }

    private void removeThreadLocalStateIfMutationAllowed(boolean mutationAllowed) {
        if (mutationAllowed) {
            this.mutationGuardState.remove();
        }
    }

    private static class GuardState
    extends ThreadLocal<Boolean> {
        private GuardState() {
        }

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    }
}

