/*
 * Decompiled with CFR 0.152.
 */
package com.mendix.logging;

import com.mendix.logging.ILogNode;
import com.mendix.logging.LogLevel;
import com.mendix.logging.LogMessage;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LogSubscriber
extends Observable {
    private final String name;
    private LogLevel autoSubscribeLevel;
    private final Map<ILogNode, LogLevel> subscriptions = new ConcurrentHashMap<ILogNode, LogLevel>();

    public LogSubscriber(String string, LogLevel logLevel) {
        if (string == null || string.isEmpty()) {
            throw new RuntimeException("LogSubscriber name cannot be empty");
        }
        this.name = string;
        this.autoSubscribeLevel = logLevel;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "";
    }

    public abstract void processMessage(LogMessage var1);

    public LogLevel getAutoSubscribeLevel() {
        return this.autoSubscribeLevel;
    }

    public void setAutoSubscribeLevel(LogLevel logLevel) {
        this.autoSubscribeLevel = logLevel;
    }

    public void subscribe(ILogNode iLogNode, LogLevel logLevel) {
        if (LogLevel.NONE.equals((Object)logLevel)) {
            this.subscriptions.remove(iLogNode);
        } else {
            this.subscriptions.put(iLogNode, logLevel);
        }
    }

    public void unsubscribe(ILogNode iLogNode) {
        this.subscribe(iLogNode, LogLevel.NONE);
    }

    public void unsubscribe() {
        for (ILogNode iLogNode : this.subscriptions.keySet()) {
            this.subscribe(iLogNode, LogLevel.NONE);
        }
    }

    public void destroy() {
        this.unsubscribe();
    }

    public Map<ILogNode, LogLevel> getSubscriptions() {
        return this.subscriptions;
    }
}

