/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.util.UrlPathHelper;

public abstract class ServletRequestPathUtils {
    public static final String PATH_ATTRIBUTE = ServletRequestPathUtils.class.getName() + ".PATH";

    public static RequestPath parseAndCache(HttpServletRequest request) {
        String requestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
        requestUri = requestUri != null ? requestUri : request.getRequestURI();
        RequestPath requestPath = RequestPath.parse(requestUri, request.getContextPath());
        request.setAttribute(PATH_ATTRIBUTE, (Object)requestPath);
        return requestPath;
    }

    public static RequestPath getParsedRequestPath(ServletRequest request) {
        RequestPath path = (RequestPath)request.getAttribute(PATH_ATTRIBUTE);
        Assert.notNull((Object)path, (String)("Expected parsed RequestPath in request attribute \"" + PATH_ATTRIBUTE + "\"."));
        return path;
    }

    public static void setParsedRequestPath(@Nullable RequestPath requestPath, ServletRequest request) {
        if (requestPath != null) {
            request.setAttribute(PATH_ATTRIBUTE, (Object)requestPath);
        } else {
            request.removeAttribute(PATH_ATTRIBUTE);
        }
    }

    public static boolean hasParsedRequestPath(ServletRequest request) {
        return request.getAttribute(PATH_ATTRIBUTE) != null;
    }

    public static void clearParsedRequestPath(ServletRequest request) {
        request.removeAttribute(PATH_ATTRIBUTE);
    }

    public static Object getCachedPath(ServletRequest request) {
        String lookupPath = (String)request.getAttribute(UrlPathHelper.PATH_ATTRIBUTE);
        if (lookupPath != null) {
            return lookupPath;
        }
        RequestPath requestPath = (RequestPath)request.getAttribute(PATH_ATTRIBUTE);
        if (requestPath != null) {
            return requestPath.pathWithinApplication();
        }
        throw new IllegalArgumentException("Neither a pre-parsed RequestPath nor a pre-resolved String lookupPath is available.");
    }

    public static String getCachedPathValue(ServletRequest request) {
        Object path = ServletRequestPathUtils.getCachedPath(request);
        if (path instanceof PathContainer) {
            String value = ((PathContainer)path).value();
            path = UrlPathHelper.defaultInstance.removeSemicolonContent(value);
        }
        return (String)path;
    }

    public static boolean hasCachedPath(ServletRequest request) {
        return request.getAttribute(PATH_ATTRIBUTE) != null || request.getAttribute(UrlPathHelper.PATH_ATTRIBUTE) != null;
    }
}

